/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.HashSet;
import org.python.antlr.AST;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyFloat;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class ArgParser {
    private String funcname;
    private PyObject[] args;
    private String[] kws;
    private String[] params = null;
    private static Object required = new Object();
    private static String[] emptyKws = new String[0];

    private ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray) {
        this.funcname = string;
        this.args = pyObjectArray;
        if (stringArray == null) {
            stringArray = emptyKws;
        }
        this.kws = stringArray;
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String string2) {
        this(string, pyObjectArray, stringArray);
        this.params = new String[]{string2};
        this.check();
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String string2, String string3) {
        this(string, pyObjectArray, stringArray);
        this.params = new String[]{string2, string3};
        this.check();
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String string2, String string3, String string4) {
        this(string, pyObjectArray, stringArray);
        this.params = new String[]{string2, string3, string4};
        this.check();
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String[] stringArray2) {
        this(string, pyObjectArray, stringArray);
        this.params = stringArray2;
        this.check();
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String[] stringArray2, int n) {
        this(string, pyObjectArray, stringArray);
        this.params = stringArray2;
        this.check();
        if (!PyBuiltinCallable.DefaultInfo.check(pyObjectArray.length, n, this.params.length)) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(pyObjectArray.length, false, string, n, this.params.length);
        }
    }

    public ArgParser(String string, PyObject[] pyObjectArray, String[] stringArray, String[] stringArray2, int n, boolean bl) {
        this(string, pyObjectArray, stringArray);
        this.params = stringArray2;
        this.check();
        if (!AST.check(pyObjectArray.length - stringArray.length, n, bl)) {
            throw AST.unexpectedCall(n, string);
        }
    }

    public String getString(int n) {
        return (String)this.getArg(n, String.class, "string");
    }

    public String getString(int n, String string) {
        return (String)this.getArg(n, String.class, "string", string);
    }

    public int getInt(int n) {
        return this.asInt(this.getRequiredArg(n));
    }

    public int getInt(int n, int n2) {
        PyObject pyObject = this.getOptionalArg(n);
        if (pyObject == null) {
            return n2;
        }
        return this.asInt(pyObject);
    }

    private int asInt(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            Py.warning(Py.DeprecationWarning, "integer argument expected, got float");
            pyObject = pyObject.__int__();
        }
        return pyObject.asInt();
    }

    public PyObject getPyObject(int n) {
        return this.getRequiredArg(n);
    }

    public PyObject getPyObject(int n, PyObject pyObject) {
        PyObject pyObject2 = this.getOptionalArg(n);
        if (pyObject2 == null) {
            pyObject2 = pyObject;
        }
        return pyObject2;
    }

    public PyObject getPyObjectByType(int n, PyType pyType) {
        PyObject pyObject = this.getRequiredArg(n);
        if (!Py.isInstance(pyObject, pyType)) {
            throw Py.TypeError(String.format("argument %d must be %s, not %s", n + 1, pyType.fastGetName(), pyObject.getType().fastGetName()));
        }
        return pyObject;
    }

    public PyObject getList(int n) {
        int n2 = this.args.length - this.kws.length;
        if (n < n2) {
            PyObject[] pyObjectArray = new PyObject[n2 - n];
            System.arraycopy(this.args, n, pyObjectArray, 0, n2 - n);
            return new PyTuple(pyObjectArray);
        }
        return Py.EmptyTuple;
    }

    public void noKeywords() {
        if (this.kws.length > 0) {
            throw Py.TypeError(String.format("%s does not take keyword arguments", this.funcname));
        }
    }

    private void check() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = this.args.length - this.kws.length;
        for (int i = 0; i < this.kws.length; ++i) {
            int n2;
            block4: {
                for (n2 = 0; n2 < this.params.length; ++n2) {
                    if (!this.kws[i].equals(this.params[n2])) continue;
                    if (n2 < n) {
                        throw Py.TypeError("keyword parameter '" + this.params[n2] + "' was given by position and by name");
                    }
                    if (hashSet.contains(n2)) {
                        throw Py.TypeError(String.format("%s got multiple values for keyword argument '%s'", this.funcname, this.params[n2]));
                    }
                    break block4;
                }
                throw Py.TypeError("'" + this.kws[i] + "' is an invalid keyword " + "argument for this function");
            }
            hashSet.add(n2);
        }
    }

    private PyObject getRequiredArg(int n) {
        PyObject pyObject = this.getOptionalArg(n);
        if (pyObject == null) {
            throw Py.TypeError(this.funcname + ": The " + ArgParser.ordinal(n) + " argument is required");
        }
        return pyObject;
    }

    private PyObject getOptionalArg(int n) {
        int n2 = this.args.length - this.kws.length;
        if (n < n2) {
            return this.args[n];
        }
        for (int i = 0; i < this.kws.length; ++i) {
            if (!this.kws[i].equals(this.params[n])) continue;
            return this.args[n2 + i];
        }
        return null;
    }

    private Object getArg(int n, Class clazz, String string) {
        return this.getArg(n, clazz, string, required);
    }

    private Object getArg(int n, Class clazz, String string, Object object) {
        PyObject pyObject = null;
        if (object == required) {
            pyObject = this.getRequiredArg(n);
        } else {
            pyObject = this.getOptionalArg(n);
            if (pyObject == null) {
                return object;
            }
        }
        Object object2 = pyObject.__tojava__(clazz);
        if (object2 == Py.NoConversion) {
            throw Py.TypeError("argument " + (n + 1) + ": expected " + string + ", " + pyObject.getType().fastGetName() + " found");
        }
        return object2;
    }

    private static String ordinal(int n) {
        switch (n + 1) {
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return Integer.toString(n + 1) + "th";
    }
}

